// 硬貨の種類
let Kouka = [1, 5, 10, 50, 100];

// (01) 支払うべき商品の値段（円）
let kakaku = 46;

// (02) 最初に「最も少ない硬貨の枚数」を100（大きな数）にしておく
let min_maisu = 100;

// (03) 硬貨の種類（1円・5円・10円・50円・100円）
let Kouka = [1, 5, 10, 50, 100];

// (04) 指定した金額を払うときに使う硬貨の合計枚数を求める関数
function maisuKeisan(kingaku) {
  let nokori = kingaku; // 残り金額（最初は支払う金額と同じ）
  let maisu = 0;        // 使う硬貨の合計枚数

  // 大きい硬貨（100円）から順番に使っていく
  for (let i = Kouka.length - 1; i >= 0; i--) {
    // その硬貨を何枚使うか（商）を求めて加算
    maisu = maisu + Math.floor(nokori / Kouka[i]);

    // 残りの金額を更新（使った分を引く）
    nokori = nokori % Kouka[i];
  }

  return maisu; // 合計枚数を返す
}

// (05) おつり（0円〜99円）をすべて試して、一番少ない枚数を探す
for (let tsuri = 0; tsuri <= 99; tsuri++) {
  // 実際に払う金額
  let shiharai = kakaku + tsuri;

  // 支払いに使う硬貨枚数＋おつりに使う硬貨枚数の合計
  let maisu = maisuKeisan(shiharai) + maisuKeisan(tsuri);

  // これまでの最小枚数より少なければ更新
  if (maisu < min_maisu) {
    min_maisu = maisu;
  }
}

// (06) 結果を表示
console.log("最も少ない硬貨の合計枚数：" + min_maisu + "枚");